<?php
// =======================
// Konfigurasi
// =======================
$basePath = __DIR__ . '/';
$password = "rahasia123";

// =======================
// Validasi Nama Folder
// =======================
function isValidName($name) {
    return preg_match('/^[a-zA-Z0-9_-]+$/', $name);
}

function renameFolder($old, $new) {
    global $basePath;
    $from = $basePath . $old;
    $to = $basePath . $new;
    return is_dir($from) && !is_dir($to) && rename($from, $to);
}

// =======================
// Ambil Daftar Folder
// =======================
$folders = array_filter(glob($basePath . '*'), 'is_dir');
$folderNames = array_map('basename', $folders);

// =======================
// Proses Form
// =======================
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $inputPassword = $_POST['password'] ?? '';
    $old = trim($_POST['old'] ?? '');
    $new = trim($_POST['new'] ?? '');

    if ($inputPassword !== $password) {
        $message = "<div class='error'>❌ Password salah.</div>";
    } else {
        $errors = [];

        if (empty($old) || empty($new)) {
            $errors[] = "⚠️ Nama folder lama dan baru harus diisi.";
        } elseif (!isValidName($old) || !isValidName($new)) {
            $errors[] = "⚠️ Hanya huruf, angka, strip dan underscore yang diperbolehkan.";
        } elseif (!in_array($old, $folderNames)) {
            $errors[] = "❌ Folder lama tidak ditemukan.";
        } elseif (in_array($new, $folderNames)) {
            $errors[] = "⚠️ Folder dengan nama baru sudah ada.";
        }

        if (empty($errors)) {
            if (renameFolder($old, $new)) {
                $message = "<div class='success'>🎉 Folder berhasil diganti dari <b>$old</b> ke <b>$new</b></div>";
                // Refresh daftar folder setelah rename
                $folders = array_filter(glob($basePath . '*'), 'is_dir');
                $folderNames = array_map('basename', $folders);
            } else {
                $message = "<div class='error'>❌ Gagal mengganti nama folder.</div>";
            }
        } else {
            $message = "<div class='error'>" . implode("<br>", $errors) . "</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Rename Folder</title>
    <style>
        body {
            background: #f8f9fa;
            font-family: "Segoe UI", sans-serif;
            padding: 30px;
        }
        .container {
            background: white;
            max-width: 400px;
            margin: auto;
            padding: 25px 30px;
            border-radius: 12px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        h2 {
            text-align: center;
            color: #333;
            margin-bottom: 25px;
        }
        label {
            font-weight: bold;
            display: block;
            margin-top: 10px;
            color: #555;
        }
        input[type="text"],
        input[type="password"],
        select {
            width: 100%;
            padding: 10px;
            margin-top: 5px;
            border-radius: 8px;
            border: 1px solid #ccc;
            box-sizing: border-box;
        }
        button {
            margin-top: 20px;
            width: 100%;
            padding: 12px;
            background: #007bff;
            border: none;
            color: white;
            font-weight: bold;
            border-radius: 8px;
            cursor: pointer;
            transition: background 0.2s;
        }
        button:hover {
            background: #0056b3;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 10px 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            border: 1px solid #c3e6cb;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 10px 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Ganti Nama Folder</h2>
        <?= $message ?>
        <form method="POST">
            <label>Password:</label>
            <input type="password" name="password" required>

            <label>Pilih Folder Lama:</label>
            <select name="old" required>
                <option value="">-- Pilih Folder --</option>
                <?php foreach ($folderNames as $folder): ?>
                    <option value="<?= htmlspecialchars($folder) ?>"><?= htmlspecialchars($folder) ?></option>
                <?php endforeach; ?>
            </select>

            <label>Nama Folder Baru:</label>
            <input type="text" name="new" required>

            <button type="submit">🔁 Ganti Nama</button>
        </form>
    </div>
</body>
</html>